function [GN, x_new] = effShiftTransmLogic(x, prof, dyn, veh)
%effShiftTransmLogic "effShift" transmission logic from VECTO

gbCtrl = veh.gb.ctrl;

% States
lastDownshiftTime = x{1};
lastUpshiftTime = x{2};

% Other inputs
GN_prev = prof.gearNumber;
engSpd = prof.engSpd;
engTrq = prof.engTrq;
time = prof.time;

maxGear = length(veh.gb.gear);

% General requirements for shifting
lastShift = max(lastDownshiftTime, lastUpshiftTime);

downshiftReq = ( time > (lastShift + gbCtrl.shiftMinTime) ) & ( time > (lastUpshiftTime + gbCtrl.downshiftDelay) ) & ( GN_prev > 0 );
upshiftReq = ( time > (lastShift + gbCtrl.shiftMinTime) ) & ( time > (lastDownshiftTime + gbCtrl.upshiftDelay) ) & ( dyn.vehAcc >= 0 ) & ( GN_prev < maxGear );

%% Vehicle start
if ( GN_prev == 0 ) && ( dyn.vehAcc > 0 )
    % Emergency upshift
    GN = GN_prev + 1;
    lastUpshiftTime = time;
    updateState
    return
end

%% Emergency shifts
% TODO Shift to neutral %
if ( GN_prev > 1 ) && ( engSpd < veh.eng.idleSpd )
    % Emergency downshift
    GN = GN_prev - 1;
    updateState
    return
elseif ( GN_prev < maxGear ) && ( engSpd > gbCtrl.n_P98h )
    % Emergency upshift
    GN = GN_prev + 1;
    lastUpshiftTime = time;
    updateState
    return
end

%% Polygon shifts
if downshiftReq
    if ( engSpd < gbCtrl.n_1 ) && ( GN_prev > 1 )
        GN = GN_prev - 1;
        lastDownshiftTime = time;
        updateState
        return
    elseif ( engSpd > gbCtrl.n_1 ) && ( engSpd < gbCtrl.n_T99 ) && ( engTrq > 0.98 * veh.eng.maxTrq( engSpd ) )
        GN = GN_prev - 1;
        lastDownshiftTime = time;
        updateState
        return
    end
end

if upshiftReq
    if ( engSpd > gbCtrl.n_P98h )
        GN = GN_prev + 1;
        lastUpshiftTime = time;
        updateState
        return
    end
end

%% Efficiency shift
% Evaluate GN candidates
if downshiftReq && upshiftReq && GN_prev > 3
    GNset = (-gbCtrl.maxGearSkip:1:gbCtrl.maxGearSkip)' + GN_prev;
elseif downshiftReq && ~upshiftReq && GN_prev > 3
    % Only downshift is possible
    GNset = (-gbCtrl.maxGearSkip:1:0)' + GN_prev;
elseif ~downshiftReq && upshiftReq && GN_prev > 3
    % Only upshift is possible
    GNset = (0:1:gbCtrl.maxGearSkip)' + GN_prev;
else
    % No eff shifting allowed
    GN = GN_prev;
    updateState
    return
end

% Remove GN candidates  < 1 or > the max GN
GNset(GNset<1) = [];
GNset(GNset>maxGear) = [];
[~, ~, prof] = convModel({GN_prev}, {GNset, 0}, dyn, veh);

fuelFlwRateSet = [prof.fuelFlwRate];
spdRatioSet = [veh.gb.gear(GNset).spdRatio]';
engPwrSet =  [prof.engSpd] .* [prof.engTrq];
engSpdSet =  [prof.engSpd];

% Requirements:
spdReqDown = spdRatioSet <= ( gbCtrl.ratioEarlyDown / veh.fd.spdRatio );
spdReqUp = spdRatioSet <= ( gbCtrl.ratioEarlyUp / veh.fd.spdRatio );

polygonReqDown = ( engSpdSet > gbCtrl.n_1 );
polygonReqUp = ( engSpdSet < gbCtrl.n_P98h );

trqResReq = 1 - engPwrSet ./ ( veh.eng.maxTrq( engSpdSet ) .* engSpdSet ) > gbCtrl.trqRes;
fuelFlwRateCurrentGear = fuelFlwRateSet( GNset == GN_prev );
pwrReq = true(size(GNset)); % effUpShiftCond3 = engPwrSet >= engPwr;
fuelReq = fuelFlwRateSet < fuelFlwRateCurrentGear * gbCtrl.effHyst;

effReqUp = spdReqUp & polygonReqDown & trqResReq & pwrReq & fuelReq;
effReqDown = spdReqDown & polygonReqUp & trqResReq & fuelReq;

% Combine all requirements
effReq = effReqUp;
effReq( GNset < GN_prev ) = effReqDown( GNset < GN_prev );

if any(effReq)
    % Find min FC GN
    cost = fuelFlwRateSet;
    cost(~effReq) = inf;
    [~, idx] = min( cost );
    GN = GNset(idx);
else
    GN = GN_prev;
end

updateState
return

%% Nested function to update states
    function updateState()
        if GN < GN_prev
            lastDownshiftTime = time;
        elseif GN > GN_prev
            lastUpshiftTime = time;
        end

        x_new{1} = lastDownshiftTime;
        x_new{2} = lastUpshiftTime;
    end

end